<?php
// test_env_config.php - Test de la configuration avec variables d'environnement
echo "=== TEST DE CONFIGURATION AVEC .ENV ===\n";

try {
    require_once 'EnvLoader.php';
    
    echo "✅ EnvLoader chargé\n";
    
    // Test de chargement du fichier .env
    EnvLoader::load();
    echo "✅ Fichier .env chargé\n";
    
    // Vérifier les variables importantes
    $requiredVars = ['DB_HOST', 'DB_NAME', 'DB_USER', 'DB_PASS', 'JWT_SECRET'];
    foreach ($requiredVars as $var) {
        $value = EnvLoader::get($var);
        if ($value !== null) {
            if (strpos($var, 'PASS') !== false || strpos($var, 'SECRET') !== false) {
                echo "✅ $var: ***masqué*** (longueur: " . strlen($value) . ")\n";
            } else {
                echo "✅ $var: $value\n";
            }
        } else {
            echo "❌ $var: MANQUANT\n";
        }
    }
    
    echo "\n=== TEST DE LA CLASSE DatabaseConfig ===\n";
    require_once 'config.php';
    
    // Test de récupération de la config de sécurité
    $securityConfig = DatabaseConfig::getSecurityConfig();
    echo "✅ Configuration de sécurité récupérée:\n";
    foreach ($securityConfig as $key => $value) {
        if (strpos($key, 'secret') !== false) {
            echo "  - $key: ***masqué*** (longueur: " . strlen($value) . ")\n";
        } else {
            echo "  - $key: $value\n";
        }
    }
    
    // Test de l'environnement
    $isDev = DatabaseConfig::isDevelopment();
    echo "✅ Environnement de développement: " . ($isDev ? 'OUI' : 'NON') . "\n";
    
    // Test de la configuration DB (sans connexion réelle)
    echo "\n=== VÉRIFICATION CONFIGURATION DB ===\n";
    
    // Utiliser la réflexion pour accéder aux variables privées
    $reflection = new ReflectionClass('DatabaseConfig');
    $initMethod = $reflection->getMethod('initConfig');
    $initMethod->setAccessible(true);
    
    try {
        $initMethod->invoke(null);
        echo "✅ Configuration DB initialisée correctement\n";
        echo "✅ Toutes les variables d'environnement DB sont disponibles\n";
    } catch (Exception $e) {
        echo "❌ Erreur d'initialisation: " . $e->getMessage() . "\n";
    }
    
    echo "\n=== RÉSUMÉ ===\n";
    echo "✅ Variables d'environnement externalisées avec succès\n";
    echo "✅ Credentials de DB sécurisés (plus dans le code source)\n";
    echo "✅ Configuration modulaire et flexible\n";
    echo "✅ Fichier .env protégé par .gitignore\n";
    
} catch (Exception $e) {
    echo "❌ Erreur: " . $e->getMessage() . "\n";
}
?>