<?php
// migrate_passwords.php - Script pour hasher les mots de passe existants
require_once 'config.php';

echo "=== MIGRATION DES MOTS DE PASSE ===\n";

try {
    $pdo = DatabaseConfig::getConnection();
    
    // Récupérer tous les utilisateurs avec mots de passe en clair
    $sql = "SELECT NUt, NomUt, MotPasse FROM user WHERE actif = 1";
    $stmt = $pdo->query($sql);
    $users = $stmt->fetchAll();
    
    echo "Utilisateurs trouvés: " . count($users) . "\n";
    
    $migrated = 0;
    foreach ($users as $user) {
        // Vérifier si le mot de passe est déjà hashé
        if (password_get_info($user['MotPasse'])['algoName'] === 'unknown') {
            // Le mot de passe n'est pas hashé, on le hash
            $hashedPassword = password_hash($user['MotPasse'], PASSWORD_DEFAULT);
            
            $updateSql = "UPDATE user SET MotPasse = :motPasse WHERE NUt = :id";
            $updateStmt = $pdo->prepare($updateSql);
            $updateStmt->bindParam(':motPasse', $hashedPassword, PDO::PARAM_STR);
            $updateStmt->bindParam(':id', $user['NUt'], PDO::PARAM_INT);
            
            if ($updateStmt->execute()) {
                echo "✅ Mot de passe hashé pour: " . $user['NomUt'] . "\n";
                $migrated++;
            } else {
                echo "❌ Erreur pour: " . $user['NomUt'] . "\n";
            }
        } else {
            echo "ℹ️  Mot de passe déjà hashé pour: " . $user['NomUt'] . "\n";
        }
    }
    
    echo "\n=== RÉSULTATS ===\n";
    echo "Mots de passe migrés: $migrated\n";
    echo "Migration terminée avec succès!\n";
    
    // Test de connexion avec les nouveaux mots de passe
    echo "\n=== TEST DE CONNEXION ===\n";
    require_once 'auth.php';
    $authService = new AuthService();
    
    // Test avec ADMIN/ADMIN2024 si c'est un utilisateur par défaut
    $testUsers = [
        ['username' => 'ADMIN', 'password' => 'ADMIN2024'],
        ['username' => 'DEMO', 'password' => 'DEMO2024']
    ];
    
    foreach ($testUsers as $testUser) {
        $result = $authService->login($testUser['username'], $testUser['password']);
        if ($result) {
            echo "✅ Test connexion OK pour: " . $testUser['username'] . "\n";
        } else {
            echo "❌ Test connexion échoué pour: " . $testUser['username'] . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Erreur during migration: " . $e->getMessage() . "\n";
}

echo "\nMigration terminée.\n";
?>