<?php
// version.php - Endpoint simple pour vérifier les versions
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

function jsonResponse($data, $success = true, $message = '') {
    $response = [
        'success' => $success,
        'data' => $data,
        'message' => $message,
        'timestamp' => date('Y-m-d H:i:s')
    ];
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    // Informations de version de l'application
    $manifestPath = __DIR__ . '/manifest.json';
    $version = [
        'app_version' => '1.0.0',
        'api_version' => '1.0.0',
        'last_updated' => date('Y-m-d H:i:s'),
        'build_number' => date('YmdHis'),
        'cache_version' => 'kombar-ferd-v1.0.0',
        'current_time' => date('Y-m-d H:i:s'),
        'endpoint' => 'version.php (standalone)'
    ];
    
    // Lire la version du manifest si disponible
    if (file_exists($manifestPath)) {
        $manifestContent = file_get_contents($manifestPath);
        $manifest = json_decode($manifestContent, true);
        if ($manifest && isset($manifest['version'])) {
            $version['app_version'] = $manifest['version'];
        }
        $version['manifest_last_modified'] = date('Y-m-d H:i:s', filemtime($manifestPath));
    }
    
    // Ajouter les timestamps des fichiers principaux
    $mainFiles = [
        'index.html' => __DIR__ . '/index.html',
        'sw.js' => __DIR__ . '/sw.js',
        'notification-watcher.js' => __DIR__ . '/notification-watcher.js',
        'manifest.json' => __DIR__ . '/manifest.json'
    ];
    
    foreach ($mainFiles as $name => $path) {
        if (file_exists($path)) {
            $version['files'][$name] = [
                'last_modified' => date('Y-m-d H:i:s', filemtime($path)),
                'size' => filesize($path),
                'exists' => true
            ];
        } else {
            $version['files'][$name] = [
                'exists' => false
            ];
        }
    }
    
    jsonResponse($version, true, 'Informations de version récupérées (standalone)');
    
} catch (Exception $e) {
    jsonResponse(['error' => $e->getMessage()], false, 'Erreur lors de la récupération de version');
}
?>