<?php
// test_connection.php - Script de test de connexion DB
echo "=== TEST DE CONNEXION ===\n";

try {
    echo "Tentative de connexion directe...\n";
    
    // Connexion directe sans utiliser la classe
    $dsn = "mysql:host=serverkmaf.helioho.st;port=3306;dbname=kombarferd_gestpeseedb;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    $pdo = new PDO($dsn, 'kombarferd_dbadmin', 'dbadmin@2024', $options);
    echo "✅ Connexion à la base de données réussie!\n";
    
    // Test de requête simple
    $stmt = $pdo->query("SELECT 1 as test");
    $result = $stmt->fetch();
    echo "✅ Test de requête OK: " . $result['test'] . "\n";
    
    // Vérifier les tables
    $tables = ['user', 'pesee'];
    foreach ($tables as $table) {
        try {
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM $table");
            $count = $stmt->fetch()['count'];
            echo "✅ Table $table: $count entrées\n";
        } catch (Exception $e) {
            echo "❌ Table $table inaccessible: " . $e->getMessage() . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Erreur de connexion: " . $e->getMessage() . "\n";
    echo "Détails:\n";
    echo "- Host: serverkmaf.helioho.st\n";
    echo "- DB: kombarferd_gestpeseedb\n";
    echo "- User: kombarferd_dbadmin\n";
}
?>