-- Scripts SQL pour supporter les tokens JWT
-- À exécuter sur votre base de données

-- Table de blacklist des tokens JWT
CREATE TABLE IF NOT EXISTS token_blacklist (
    id INT AUTO_INCREMENT PRIMARY KEY,
    jti VARCHAR(255) NOT NULL UNIQUE COMMENT 'JWT ID unique',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NULL COMMENT 'Date d\'expiration du token original',
    INDEX idx_jti (jti),
    INDEX idx_created_at (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Blacklist des tokens JWT révoqués';

-- Mettre à jour la table user pour supporter les nouvelles fonctionnalités
ALTER TABLE user 
ADD COLUMN IF NOT EXISTS derniere_connexion TIMESTAMP NULL COMMENT 'Dernière connexion réussie',
ADD COLUMN IF NOT EXISTS tentatives_connexion INT DEFAULT 0 COMMENT 'Nombre de tentatives de connexion échouées',
ADD COLUMN IF NOT EXISTS bloque_jusqu TIMESTAMP NULL COMMENT 'Utilisateur bloqué jusqu\'à cette date';

-- Index pour optimiser les requêtes
ALTER TABLE user 
ADD INDEX IF NOT EXISTS idx_derniere_connexion (derniere_connexion),
ADD INDEX IF NOT EXISTS idx_bloque_jusqu (bloque_jusqu);

-- Procédure pour nettoyer les vieux tokens blacklistés (optionnel)
DELIMITER $$
CREATE PROCEDURE IF NOT EXISTS CleanExpiredTokens()
BEGIN
    -- Supprimer les tokens expirés depuis plus de 7 jours
    DELETE FROM token_blacklist 
    WHERE created_at < DATE_SUB(NOW(), INTERVAL 7 DAY);
END$$
DELIMITER ;

-- Événement pour nettoyer automatiquement (optionnel - nécessite EVENT_SCHEDULER=ON)
-- CREATE EVENT IF NOT EXISTS cleanup_tokens
-- ON SCHEDULE EVERY 24 HOUR
-- DO CALL CleanExpiredTokens();

-- Insérer quelques données de test si nécessaire
INSERT IGNORE INTO user (NomUt, MotPasse, NomPrenoms, LeGroupe, actif) VALUES
('ADMIN', '$2y$12$dummy_hash_replace_with_real', 'Administrateur', 'admin', 1),
('DEMO', '$2y$12$dummy_hash_replace_with_real', 'Démonstration', 'user', 1);

-- Commenter ou supprimer la ligne ci-dessus après avoir exécuté migrate_passwords.php