<?php
// api/models/Produit.php
class Produit extends BaseModel {
    protected $table = 'produits';
    protected $fillable = [
        'nom', 'unite_mesure', 'categorie', 'description', 'actif'
    ];
    
    public function getStocksBySite() {
        $stmt = $this->db->prepare("
            SELECT s.*, si.nom as site_nom
            FROM stocks s
            JOIN sites si ON s.site_id = si.id
            WHERE s.produit_id = ? AND s.quantite_actuelle > 0
            ORDER BY si.nom
        ");
        $stmt->execute([$this->id]);
        return $stmt->fetchAll();
    }
    
    public function getTotalStock() {
        $stmt = $this->db->prepare("SELECT SUM(quantite_actuelle) as total FROM stocks WHERE produit_id = ?");
        $stmt->execute([$this->id]);
        $result = $stmt->fetch();
        return $result['total'] ?? 0;
    }
    
    public function validate($data, $isUpdate = false) {
        $rules = [
            'nom' => ['required' => true, 'max_length' => 100],
            'unite_mesure' => ['required' => true, 'in_array' => ['kg', 'tonne', 'sac', 'litre']],
            'categorie' => ['required' => true, 'in_array' => ['cereale', 'legumineuse', 'tubercule', 'autre']],
            'description' => ['max_length' => 500]
        ];
        
        return Validator::validate($data, $rules);
    }
}
?>