<?php
	// api/models/Fournisseur.php

class Fournisseur extends BaseModel {
    protected $table = 'fournisseurs';
    protected $fillable = [
        'nom', 'telephone', 'adresse', 'type_produit', 'actif'
    ];
    
    public function getAchats($limit = null) {
        $sql = "SELECT * FROM achats WHERE fournisseur_id = ? ORDER BY date_achat DESC";
        if ($limit) {
            $sql .= " LIMIT $limit";
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$this->id]);
        return $stmt->fetchAll();
    }
    
    public function getTotalAchats($year = null) {
        $sql = "SELECT COALESCE(SUM(cout_total), 0) as total FROM achats WHERE fournisseur_id = ?";
        $params = [$this->id];
        
        if ($year) {
            $sql .= " AND YEAR(date_achat) = ?";
            $params[] = $year;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        $result = $stmt->fetch();
        return $result['total'];
    }
    
    public function validate($data, $isUpdate = false) {
        $rules = [
            'nom' => ['required' => true, 'max_length' => 100],
            'telephone' => ['max_length' => 20],
            'adresse' => ['max_length' => 500],
            'type_produit' => ['max_length' => 50]
        ];
        
        return Validator::validate($data, $rules);
    }
}
?>