<?php
	// api/models/Client.php

class Client extends BaseModel {
    protected $table = 'clients';
    protected $fillable = [
        'nom', 'telephone', 'adresse', 'type_client', 'limite_credit', 'actif'
    ];
    
    public function getVentes($limit = null) {
        $sql = "SELECT * FROM ventes WHERE client_id = ? ORDER BY date_vente DESC";
        if ($limit) {
            $sql .= " LIMIT $limit";
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute([$this->id]);
        return $stmt->fetchAll();
    }
    
    public function getTotalVentes($year = null) {
        $sql = "SELECT COALESCE(SUM(montant_total), 0) as total FROM ventes WHERE client_id = ?";
        $params = [$this->id];
        
        if ($year) {
            $sql .= " AND YEAR(date_vente) = ?";
            $params[] = $year;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        $result = $stmt->fetch();
        return $result['total'];
    }
    
    public function validate($data, $isUpdate = false) {
        $rules = [
            'nom' => ['required' => true, 'max_length' => 100],
            'telephone' => ['max_length' => 20],
            'adresse' => ['max_length' => 500],
            'type_client' => ['required' => true, 'in_array' => ['grossiste', 'detaillant', 'particulier']],
            'limite_credit' => ['numeric' => true, 'positive' => true]
        ];
        
        return Validator::validate($data, $rules);
    }
}

?>