// api/models/Budget.php
<?php
class Budget extends BaseModel {
    protected $table = 'budgets';
    protected $fillable = [
        'site_id', 'montant_initial', 'montant_actuel', 'devise',
        'periode_debut', 'periode_fin', 'statut'
    ];
    
    public function getSite() {
        $stmt = $this->db->prepare("SELECT * FROM sites WHERE id = ?");
        $stmt->execute([$this->site_id]);
        return $stmt->fetch();
    }
    
    public function getUsagePercentage() {
        if ($this->montant_initial <= 0) return 0;
        return (($this->montant_initial - $this->montant_actuel) / $this->montant_initial) * 100;
    }
    
    public function updateAmount($amount, $operation = 'subtract') {
        $newAmount = $operation === 'subtract' 
            ? $this->montant_actuel - $amount 
            : $this->montant_actuel + $amount;
            
        $stmt = $this->db->prepare("UPDATE budgets SET montant_actuel = ?, last_modified = NOW() WHERE id = ?");
        return $stmt->execute([$newAmount, $this->id]);
    }
    
    public function validate($data, $isUpdate = false) {
        $rules = [
            'site_id' => ['required' => true, 'numeric' => true],
            'montant_initial' => ['required' => true, 'numeric' => true, 'positive' => true],
            'montant_actuel' => ['numeric' => true, 'positive' => true],
            'devise' => ['max_length' => 3],
            'periode_debut' => ['required' => true, 'date' => true],
            'periode_fin' => ['required' => true, 'date' => true],
            'statut' => ['in_array' => ['actif', 'suspendu', 'cloture']]
        ];
        
        return Validator::validate($data, $rules);
    }
}
?>