<?php
	// api/models/Achat.php

class Achat extends BaseModel {
    protected $table = 'achats';
    protected $fillable = [
        'site_id', 'fournisseur_id', 'produit_id', 'quantite', 'prix_unitaire',
        'montant_total', 'frais_transport', 'autres_frais', 'cout_total',
        'date_achat', 'numero_bon', 'statut', 'utilisateur_id'
    ];
    
    public function getSite() {
        $stmt = $this->db->prepare("SELECT * FROM sites WHERE id = ?");
        $stmt->execute([$this->site_id]);
        return $stmt->fetch();
    }
    
    public function getFournisseur() {
        $stmt = $this->db->prepare("SELECT * FROM fournisseurs WHERE id = ?");
        $stmt->execute([$this->fournisseur_id]);
        return $stmt->fetch();
    }
    
    public function getProduit() {
        $stmt = $this->db->prepare("SELECT * FROM produits WHERE id = ?");
        $stmt->execute([$this->produit_id]);
        return $stmt->fetch();
    }
    
    public function updateStock() {
        // Vérifier si le stock existe
        $stmt = $this->db->prepare("SELECT * FROM stocks WHERE site_id = ? AND produit_id = ?");
        $stmt->execute([$this->site_id, $this->produit_id]);
        $stock = $stmt->fetch();
        
        if ($stock) {
            // Mettre à jour le stock existant (CMUP)
            $nouvelleQuantite = $stock['quantite_actuelle'] + $this->quantite;
            $nouvelleValeur = $stock['valeur_stock'] + $this->cout_total;
            $nouveauPrix = $nouvelleQuantite > 0 ? $nouvelleValeur / $nouvelleQuantite : 0;
            
            $stmt = $this->db->prepare("
                UPDATE stocks 
                SET quantite_actuelle = ?, 
                    valeur_stock = ?, 
                    prix_moyen_pondere = ?,
                    derniere_maj = NOW()
                WHERE id = ?
            ");
            $stmt->execute([$nouvelleQuantite, $nouvelleValeur, $nouveauPrix, $stock['id']]);
            $stockId = $stock['id'];
        } else {
            // Créer un nouveau stock
            $stmt = $this->db->prepare("
                INSERT INTO stocks (site_id, produit_id, quantite_actuelle, valeur_stock, prix_moyen_pondere)
                VALUES (?, ?, ?, ?, ?)
            ");
            $prixMoyen = $this->quantite > 0 ? $this->cout_total / $this->quantite : 0;
            $stmt->execute([$this->site_id, $this->produit_id, $this->quantite, $this->cout_total, $prixMoyen]);
            $stockId = $this->db->lastInsertId();
        }
        
        // Enregistrer le mouvement de stock
        $stmt = $this->db->prepare("
            INSERT INTO mouvements_stock (stock_id, type_mouvement, quantite, prix_unitaire, reference_achat_id)
            VALUES (?, 'entree', ?, ?, ?)
        ");
        $stmt->execute([$stockId, $this->quantite, $this->prix_unitaire, $this->id]);
        
        return true;
    }
    
    public function validate($data, $isUpdate = false) {
        $rules = [
            'site_id' => ['required' => true, 'numeric' => true],
            'fournisseur_id' => ['required' => true, 'numeric' => true],
            'produit_id' => ['required' => true, 'numeric' => true],
            'quantite' => ['required' => true, 'numeric' => true, 'positive' => true],
            'prix_unitaire' => ['required' => true, 'numeric' => true, 'positive' => true],
            'date_achat' => ['required' => true, 'date' => true],
            'statut' => ['in_array' => ['en_cours', 'livre', 'paye']]
        ];
        
        return Validator::validate($data, $rules);
    }
    
    public function calculateTotals() {
        $this->montant_total = $this->quantite * $this->prix_unitaire;
        $this->cout_total = $this->montant_total + ($this->frais_transport ?? 0) + ($this->autres_frais ?? 0);
    }
}
?>