<?php
// api/health.php - Endpoint de vérification de santé de l'API

require_once 'config.php';

try {
    // Test de connexion à la base de données
    $db = Database::getInstance()->getConnection();
    $stmt = $db->query("SELECT 1 as test");
    $dbStatus = $stmt->fetch() ? 'OK' : 'ERROR';

    ApiResponse::success([
        'api_version' => API_VERSION,
        'environment' => APP_ENV,
        'database' => $dbStatus,
        'timestamp' => date('c'),
        'php_version' => PHP_VERSION,
        'status' => 'healthy'
    ], 'API est opérationnelle');

} catch (Exception $e) {
    Logger::error('Health check failed', ['error' => $e->getMessage()]);
    ApiResponse::error('API non disponible: ' . $e->getMessage(), 503);
}
?>